<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pārliecinās, vai jautājuma ID ir norādīts URL
if (!isset($_GET['id'])) {
    // Pāradresē vai rāda kļūdas ziņojumu
    header("Location: error.php");
    exit();
}

// Pieņemot, ka ir izveidots datu bāzes savienojums
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Iegūst jautājuma ID no URL parametra
$questionId = $_GET['id'];

// Izgūst jautājuma datus no datu bāzes
$sql = "SELECT * FROM questions WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $questionId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Jautājums atrasts, rāda formu rediģēšanai
    $row = $result->fetch_assoc();

    // Izgūst atbildes saistītās ar jautājumu no datu bāzes
    $sql_answers = "SELECT * FROM answers WHERE question_id = ?";
    $stmt_answers = $conn->prepare($sql_answers);
    $stmt_answers->bind_param("i", $questionId);
    $stmt_answers->execute();
    $result_answers = $stmt_answers->get_result();

    $answers = array();
    while ($row_answer = $result_answers->fetch_assoc()) {
        $answers[] = $row_answer;
    }

    // Pārbauda, vai forma ir nosūtīta, lai atjaunotu jautājumu
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Izgūst atjaunināto jautājuma tekstu no formas
        $updatedQuestion = $_POST['questionText'];

        // Atjauno jautājumu datu bāzē
        $updateSql = "UPDATE questions SET question = ? WHERE id = ?";
        $stmt = $conn->prepare($updateSql);

        if ($stmt) {
            $stmt->bind_param("si", $updatedQuestion, $questionId);
            if ($stmt->execute()) {
                echo "Jautājums veiksmīgi atjaunināts. Pāradresēšana...";
                echo "<script>setTimeout(function() { window.location.href = '../html/testu_parvaldisana.html'; }, 3000);</script>";
            } else {
                echo "Kļūda atjaunojot jautājumu: " . $conn->error;
            }
            $stmt->close();
        } else {
            echo "Kļūda sagatavojot paziņojumu: " . $conn->error;
        }

        // Atjauno atbilžu opcijas datu bāzē
        foreach ($answers as $index => $answer) {
            $optionName = 'option' . ($index + 1);
            $isCorrectName = 'isCorrect' . ($index + 1);
            $updatedOption = $_POST[$optionName];
            $isCorrect = isset($_POST[$isCorrectName]) ? 1 : 0;

            $updateAnswerSql = "UPDATE answers SET answer = ?, is_correct = ? WHERE id = ?";
            $stmtAnswer = $conn->prepare($updateAnswerSql);

            if ($stmtAnswer) {
                $stmtAnswer->bind_param("sii", $updatedOption, $isCorrect, $answer['id']);
                if ($stmtAnswer->execute()) {
                    echo "Atbilde " . ($index + 1) . " veiksmīgi atjaunināta.";
                } else {
                    echo "Kļūda atjaunojot atbildes opciju " . ($index + 1) . ": " . $conn->error;
                }
                $stmtAnswer->close();
            } else {
                echo "Kļūda sagatavojot paziņojumu atbildes opcijai " . ($index + 1) . ": " . $conn->error;
            }
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Edit Question</title>
        <style>
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f4f4f4;  
                background-image: url('fons.png');
                background-size: cover;
            }
            #navbar {
                background-color: #333;
                color: white;
                padding: 15px;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            #logo {
                cursor: pointer;
                font-size: 24px;
                font-weight: bold;
            }
            #navbar button, #profileBtn {
                cursor: pointer;
                background-color: transparent;
                color: white;
                border: none;
                font-size: 16px;
                margin: 0 10px;
                padding: 5px 10px;
                transition: all 0.3s ease;
            }
            #navbar button:hover, #profileBtn:hover {
                background-color: rgba(255, 255, 255, 0.1);
            }
            #profileBtn {
                position: relative;
            }
            .dropdown-content {
                display: none;
                position: absolute;
                background-color: #333;
                min-width: 160px;
                box-shadow: 0px 8px 16px rgba(0,0,0,0.2);
                z-index: 1;
                right: 0;
            }
            .dropdown-content a {
                color: white;
                padding: 12px 16px;
                text-decoration: none;
                display: block;
                transition: all 0.3s ease;
            }
            .dropdown-content a:hover {
                background-color: rgba(255, 255, 255, 0.1);
            }
            .dropdown:hover .dropdown-content {
                display: block;
            }
            #centerContent {
                text-align: center;
                margin-top: 50px;
            }
            #gamePinInput {
                padding: 10px;
                font-size: 16px;
                border: 1px solid #ccc;
                border-radius: 5px;
                margin-bottom: 20px;
            }
            #userID {
                font-weight: bold;
                color: #333;
            }
            #signInBtn, #registerBtn {
                cursor: pointer;
                background-color: rgba(255, 255, 255, 0.1);
                color: white;
                border: none;
                font-size: 18px;
                padding: 10px 20px;
                transition: all 0.3s ease;
            }
            #signInBtn:hover, #registerBtn:hover {
                background-color: rgba(255, 255, 255, 0.2);
            }
            .edit-form {
                background-color: white;
                max-width: 600px;
                margin: 50px auto;
                padding: 20px;
                border-radius: 10px;
                box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            }
            .edit-form label {
                display: block;
                margin-bottom: 10px;
                font-weight: bold;
            }
            .edit-form input[type="text"], .edit-form input[type="checkbox"] {
                width: 100%;
                padding: 10px;
                margin-bottom: 20px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }
            .edit-form button {
                background-color: #333;
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                transition: all 0.3s ease;
            }
            .edit-form button:hover {
                background-color: rgba(51, 51, 51, 0.8);
            }
        </style>
    </head>
    <body>
        <div id="navbar">
            <div id="logo">Logo</div>
            <div>
                <button id="profileBtn">Profile</button>
                <div class="dropdown-content">
                    <a href="#">Link 1</a>
                    <a href="#">Link 2</a>
                    <a href="#">Link 3</a>
                </div>
            </div>
        </div>
        <div class="edit-form">
            <form action="" method="POST">
                <label for="questionText">Jautājums:</label>
                <input type="text" id="questionText" name="questionText" value="<?php echo htmlspecialchars($row['question']); ?>" required>

                <?php foreach ($answers as $index => $answer): ?>
                    <label for="option<?php echo $index + 1; ?>">Atbilde <?php echo $index + 1; ?>:</label>
                    <input type="text" id="option<?php echo $index + 1; ?>" name="option<?php echo $index + 1; ?>" value="<?php echo htmlspecialchars($answer['answer']); ?>" required>
                    <label for="isCorrect<?php echo $index + 1; ?>">Pareiza atbilde:</label>
                    <input type="checkbox" id="isCorrect<?php echo $index + 1; ?>" name="isCorrect<?php echo $index + 1; ?>" <?php if ($answer['is_correct']) echo 'checked'; ?>>
                <?php endforeach; ?>

                <button type="submit">Atjaunināt jautājumu</button>
            </form>
        </div>
    </body>
    </html>
    <?php
} else {
    // Jautājums nav atrasts, pāradresē vai rāda kļūdas ziņojumu
    echo "Jautājums nav atrasts.";
}

// Aizver datu bāzes savienojumu
$conn->close();
?>
